
/**
 * @param {Array} dataObject
 * @param {Array} data
 * @param {function} selectorCb
 * @returns {Array}
 */

function colourSeries(data)
{
	var series = [];
	for (var i in data) {
		var line = [];
		for (var j in data)
			if (i == j)
				line.push([data[j][0], data[j][1]]);
			else
				line.push([data[j][0], null]);
		series.push(line);
	}
	return series;
}

function colourBars(dataObject, data, selectorCb) {
	if (selectorCb == null) {
		for (var prop in dataObject)
			data.push([prop, dataObject[prop]]);
	}
	else {
		for (var prop in dataObject) {
			var rec = selectorCb(prop, dataObject[prop]);
			if (rec != null)
				data.push(rec);
		}
	}
	return colourSeries(data);
}

function initTimeField(czasF)
{
	var czas = parseInt(czasF.val());
	if (isNaN(czas)) return;
	var hh = Math.floor(czas / 3600);
	if (isNaN(hh)) hh = '00'; else
	if (hh < 10) hh = '0' + hh;
	var mm = Math.floor(czas / 60 % 60);
	if (isNaN(mm)) mm = '00'; else
	if (mm < 10) mm = '0' + mm;
	var ss = Math.floor(czas % 60);
	if (isNaN(ss)) ss = '00'; else
	if (ss < 10) ss = '0' + ss;
	czasF.val(hh + ':' + mm + ':' + ss);
}

function serializeTimeField(czasF)
{
	var t = czasF.val().split(':');
	var value = 0;
	for (var i=t.length-1, mul=1; i>=0; i--, mul*=60)
		value += mul * parseInt(t[i]);
	if (isNaN(value)) value = '';
	czasF.val( value );
}

function generateChecksummedValue(weights)
{
	var result = '';
	var sum = 0;
	for (var i in weights) {
		var digit = Math.floor(Math.random() * 9);
		sum += weights[i] * digit;
		result = result + digit.toString();
	}
	return result + ((sum % 11) % 10).toString();
}

function generateNip()
{
	return generateChecksummedValue([6, 5, 7, 2, 3, 4, 5, 6, 7]);
}

function generateRegon9()
{
	return generateChecksummedValue([8, 9, 2, 3, 4, 5, 6, 7]);
}
